<?php
//Step 1: Load KoolReport
require_once "../../../../koolreport/autoload.php";

use \koolreport\processes\ColumnMeta;
use \koolreport\processes\Group;

//Step 2: Creating Report class
class MyReport extends \koolreport\KoolReport
{
    protected function settings()
    {
        return array(
            "dataSources"=>array(
                "data"=>array(
                    "class"=>'\koolreport\datasources\ArrayDataSource',
                    "dataFormat"=>"table",
                    "data"=>array(
                        array("item","cost"),
                        array("Accessories",3000),
                        array("Human Resource",20000),
                        array("Material",50000),
                        array("Machine",30000),
                        array("Accessories",5000),
                        array("Machine",10000),
                        array("Material",20000),                
                    )
                )
            )
        );
    }
    protected function setup()
    {
        //Prepare data
        $this->src("data")
        ->pipe(new ColumnMeta(array(
            "cost"=>array(
                "type"=>"number",
                "prefix"=>"$"
            )
        )))
        ->saveTo($source);

        //Save orginal data
        $source->pipe($this->dataStore("origin"));
        
        //Pipe through process to get result
        $source->pipe(new Group(array(
            "by"=>"item",
            "sum"=>"cost"
        )))
        ->pipe($this->dataStore("result"));
    }
}